/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi.j2xx;

import com.ftdi.j2xx.FT_Device;
import com.ftdi.j2xx.FT_EEPROM;
import com.ftdi.j2xx.FT_EE_Ctrl;

class FT_EE_232B_Ctrl
extends FT_EE_Ctrl {
    private static final short CHECKSUM_LOCATION = 63;
    private static final short EEPROM_SIZE = 64;
    private static FT_Device ft_device;

    FT_EE_232B_Ctrl(FT_Device usbC) {
        super(usbC);
        ft_device = usbC;
    }

    @Override
    short programEeprom(FT_EEPROM ee) {
        int[] data = new int[64];
        if (ee.getClass() != FT_EEPROM.class) {
            return 1;
        }
        FT_EEPROM eeprom = ee;
        try {
            for (short i = 0; i < 64; i = (short)(i + 1)) {
                data[i] = this.readWord(i);
            }
            data[1] = eeprom.VendorId;
            data[2] = eeprom.ProductId;
            data[3] = FT_EE_232B_Ctrl.ft_device.mDeviceInfoNode.bcdDevice;
            data[4] = this.setUSBConfig(ee);
            int saddr = 10;
            saddr = this.setStringDescriptor(eeprom.Manufacturer, data, saddr, 7, true);
            saddr = this.setStringDescriptor(eeprom.Product, data, saddr, 8, true);
            if (eeprom.SerNumEnable) {
                saddr = this.setStringDescriptor(eeprom.SerialNumber, data, saddr, 9, true);
            }
            if (data[1] != 0 && data[2] != 0) {
                boolean returnCode = false;
                returnCode = this.programEeprom(data, 63);
                if (returnCode) {
                    return 0;
                }
                return 1;
            }
            return 2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    FT_EEPROM readEeprom() {
        FT_EEPROM eeprom = new FT_EEPROM();
        int[] data = new int[64];
        try {
            for (int i = 0; i < 64; ++i) {
                data[i] = this.readWord((short)i);
            }
            eeprom.VendorId = (short)data[1];
            eeprom.ProductId = (short)data[2];
            this.getUSBConfig(eeprom, data[4]);
            int addr = 10;
            eeprom.Manufacturer = this.getStringDescriptor(addr, data);
            eeprom.Product = this.getStringDescriptor(addr += eeprom.Manufacturer.length() + 1, data);
            eeprom.SerialNumber = this.getStringDescriptor(addr += eeprom.Product.length() + 1, data);
            return eeprom;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    int getUserSize() {
        int data = this.readWord((short)7);
        int ptr07 = (data & 0xFF00) >> 8;
        data = this.readWord((short)8);
        int ptr08 = (data & 0xFF00) >> 8;
        int ptr = 10 + (ptr07 /= 2) + (ptr08 /= 2) + 1;
        data = this.readWord((short)9);
        int length = (data & 0xFF00) >> 8;
        return (63 - ptr - 1 - (length /= 2)) * 2;
    }

    @Override
    int writeUserData(byte[] data) {
        int i;
        int dataWrite = 0;
        short offset = 0;
        if (data.length > this.getUserSize()) {
            return 0;
        }
        int[] eeprom = new int[64];
        for (i = 0; i < 64; i = (short)(i + 1)) {
            eeprom[i] = this.readWord((short)i);
        }
        offset = (short)(63 - this.getUserSize() / 2 - 1);
        offset = (short)(offset & 0xFFFF);
        for (i = 0; i < data.length; i += 2) {
            dataWrite = i + 1 < data.length ? data[i + 1] & 0xFF : 0;
            dataWrite <<= 8;
            short s = offset;
            offset = (short)(offset + 1);
            eeprom[s] = dataWrite |= data[i] & 0xFF;
        }
        if (eeprom[1] != 0 && eeprom[2] != 0) {
            boolean returnCode = false;
            returnCode = this.programEeprom(eeprom, 63);
            if (!returnCode) {
                return 0;
            }
        } else {
            return 0;
        }
        return data.length;
    }

    @Override
    byte[] readUserData(int length) {
        byte Hi = 0;
        byte Lo = 0;
        int dataRead = 0;
        byte[] data = new byte[length];
        if (length == 0 || length > this.getUserSize()) {
            return null;
        }
        short offset = (short)(63 - this.getUserSize() / 2 - 1);
        offset = (short)(offset & 0xFFFF);
        for (int i = 0; i < length; i += 2) {
            short s = offset;
            offset = (short)(offset + 1);
            dataRead = this.readWord(s);
            if (i + 1 < data.length) {
                data[i + 1] = Hi = (byte)(dataRead & 0xFF);
            } else {
                Lo = 0;
            }
            data[i] = Lo = (byte)((dataRead & 0xFF00) >> 8);
        }
        return data;
    }
}

